{-----------------------------------------------------------------------}
{The following program is written to loosely conform to the VESA 	}
{Super VGA BIOS Extension document VS891001.  The program is intended	}
{as a demonstration and is not intended to be an example of a 		}
{high-performance implementations of the VESA standard.			}
{If you find any omissions or errors, please report them to me on the 	}
{Everex Systems BBS at (415) 683-2984.					}
{						Gary Lorensen		}
{						Everex Systems, Inc.	}
{						48571 Milmont Dr. B3	}
{						Fremont, CA   94538	}
{-----------------------------------------------------------------------}
uses
    dos;
{-----------------------------------------------------------------------}
{-----------------------------------------------------------------------}

var
    buffsave : pointer;
    buffsize : word;
    vgafile  : file;
    reg      : Registers;

{-----------------------------------------------------------------------}
{-----------------------------------------------------------------------}

begin
    if (ParamCount<2) then begin
	writeln('SAVEVESA parameters:');
	writeln('    SAVEVESA -s filename     : Save VGA state');
	writeln('    SAVEVESA -r filename     : Restore VGA state');
	writeln;
	halt(1);
    end;

    reg.AX := $4f04;
    reg.CX := $000f;
    reg.DL := $00;
    intr($10,reg);

    if (reg.AL<>$4f) then begin
        writeln('Current configuration does not support VESA Save/Restore VGA State.');
	halt(1);
    end;

    buffsize := reg.BX*$40;
    GetMem(buffsave,buffsize);

    if ((ParamStr(1)='-s') or (ParamStr(1)='-S')) then begin

	reg.AX := $4f04;
	reg.DL := $01;
	reg.CX := $000f;
	reg.ES := Seg(buffsave^);
	reg.BX := Ofs(buffsave^);
	intr($10,reg);

        assign(vgafile,ParamStr(2));
	rewrite(vgafile,1);
	BlockWrite(vgafile,buffsave^,buffsize);
	close(vgafile);

    end else if ((ParamStr(1)='-r') or (ParamStr(1)='-R')) then begin

        assign(vgafile,ParamStr(2));
	reset(vgafile,1);
	BlockRead(vgafile,buffsave^,buffsize);
	close(vgafile);

	reg.AX := $4f04;
	reg.DL := $02;
	reg.CX := $000f;
	reg.ES := Seg(buffsave^);
	reg.BX := Ofs(buffsave^);
	intr($10,reg);

    end;
    FreeMem(buffsave,buffsize);

end.

{-----------------------------------------------------------------------}
{-----------------------------------------------------------------------}


